/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.ILayerModel;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.NBTWrapper;

public class LayerModel
implements ILayerModel {
    public ItemStack model = ItemStack.field_190927_a;
    public ResourceLocation objModel = null;
    public float[] offsetAxis = new float[]{0.0f, 0.0f, 0.0f};
    public float[] scaleAxis = new float[]{1.0f, 1.0f, 1.0f};
    public float[] rotateAxis = new float[]{0.0f, 0.0f, 0.0f};
    public byte[] isRotate = new byte[]{0, 0, 0};
    public int pos = 0;
    public int rotateSpeed = 1;

    public LayerModel(int i) {
        this.pos = i;
    }

    public LayerModel(NBTTagCompound nbtLayer) {
        this.setNbt(new NBTWrapper(nbtLayer));
    }

    @Override
    public IItemStack getModel() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(this.model);
    }

    @Override
    public INbt getNbt() {
        NBTTagCompound nbtLayer = new NBTTagCompound();
        if (!this.model.func_190926_b()) {
            nbtLayer.func_74782_a("Model", (NBTBase)this.model.func_77955_b(new NBTTagCompound()));
        }
        if (this.objModel != null) {
            nbtLayer.func_74778_a("OBJModel", this.objModel.toString());
        }
        NBTTagList ra = new NBTTagList();
        for (float f : this.rotateAxis) {
            ra.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        nbtLayer.func_74782_a("RotateAxis", (NBTBase)ra);
        NBTTagList oa = new NBTTagList();
        for (float f : this.offsetAxis) {
            oa.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        nbtLayer.func_74782_a("OffsetAxis", (NBTBase)oa);
        NBTTagList sa = new NBTTagList();
        for (float f : this.scaleAxis) {
            sa.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        nbtLayer.func_74782_a("ScaleAxis", (NBTBase)sa);
        nbtLayer.func_74773_a("isRotate", this.isRotate);
        nbtLayer.func_74768_a("Pos", this.pos);
        nbtLayer.func_74768_a("Speed", this.rotateSpeed);
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(nbtLayer);
    }

    @Override
    public String getOBJModel() {
        return this.objModel.toString();
    }

    @Override
    public float getOffset(int axis) {
        if (axis < 0) {
            axis *= -1;
        }
        if (axis > 2) {
            axis %= 3;
        }
        return this.offsetAxis[axis];
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public float getRotate(int axis) {
        if (axis < 0) {
            axis *= -1;
        }
        if (axis > 2) {
            axis %= 3;
        }
        return this.rotateAxis[axis];
    }

    @Override
    public int getRotateSpeed() {
        return this.rotateSpeed;
    }

    @Override
    public float getScale(int axis) {
        if (axis < 0) {
            axis *= -1;
        }
        if (axis > 2) {
            axis %= 3;
        }
        return this.scaleAxis[axis];
    }

    @Override
    public boolean isRotate(int axis) {
        if (axis < 0) {
            axis *= -1;
        }
        if (axis > 2) {
            axis %= 3;
        }
        return this.isRotate[axis] == 1;
    }

    @Override
    public void setIsRotate(boolean x, boolean y, boolean z) {
        this.isRotate[0] = x ? (byte)1 : 0;
        this.isRotate[1] = y ? (byte)1 : 0;
        this.isRotate[2] = z ? (byte)1 : 0;
    }

    @Override
    public void setModel(IItemStack stack) {
        this.model = stack.getMCItemStack();
    }

    @Override
    public void setNbt(INbt nbt) {
        int i;
        NBTTagCompound nbtLayer = nbt.getMCNBT();
        if (nbtLayer.func_150297_b("Model", 10)) {
            this.model = new ItemStack(nbtLayer.func_74775_l("Model"));
        }
        if (nbtLayer.func_150297_b("OBJModel", 8)) {
            this.objModel = new ResourceLocation(nbtLayer.func_74779_i("OBJModel"));
        }
        if (nbtLayer.func_150295_c("RotateAxis", 5).func_74745_c() == 3) {
            for (i = 0; i < nbtLayer.func_150295_c("RotateAxis", 5).func_74745_c(); ++i) {
                this.rotateAxis[i] = nbtLayer.func_150295_c("RotateAxis", 5).func_150308_e(i);
            }
        }
        if (nbtLayer.func_150295_c("OffsetAxis", 5).func_74745_c() == 3) {
            for (i = 0; i < nbtLayer.func_150295_c("OffsetAxis", 5).func_74745_c(); ++i) {
                this.offsetAxis[i] = nbtLayer.func_150295_c("OffsetAxis", 5).func_150308_e(i);
            }
        }
        if (nbtLayer.func_150295_c("ScaleAxis", 5).func_74745_c() == 3) {
            for (i = 0; i < nbtLayer.func_150295_c("ScaleAxis", 5).func_74745_c(); ++i) {
                this.scaleAxis[i] = nbtLayer.func_150295_c("ScaleAxis", 5).func_150308_e(i);
            }
        }
        if (nbtLayer.func_74770_j("isRotate").length == 3) {
            this.isRotate = nbtLayer.func_74770_j("isRotate");
        }
        this.pos = nbtLayer.func_74762_e("Pos");
        this.setRotateSpeed(nbtLayer.func_74762_e("Speed"));
    }

    @Override
    public void setOBJModel(String path) {
        this.objModel = new ResourceLocation(path);
    }

    @Override
    public void setOffset(float x, float y, float z) {
        this.offsetAxis[0] = x;
        this.offsetAxis[1] = y;
        this.offsetAxis[2] = z;
    }

    @Override
    public void setRotate(float x, float y, float z) {
        this.rotateAxis[0] = x;
        this.rotateAxis[1] = y;
        this.rotateAxis[2] = z;
    }

    @Override
    public void setRotateSpeed(int speed) {
        if (speed < 1) {
            speed = 1;
        }
        if (speed > 7) {
            speed = 7;
        }
        this.rotateSpeed = speed;
    }

    @Override
    public void setScale(float x, float y, float z) {
        if (x < 0.1f) {
            x = 0.1f;
        }
        if (y < 0.1f) {
            y = 0.1f;
        }
        if (z < 0.1f) {
            z = 0.1f;
        }
        this.scaleAxis[0] = x;
        this.scaleAxis[1] = y;
        this.scaleAxis[2] = z;
    }
}

